#pragma once
#include "funkey.h"

#ifndef _XJ_MACRO_DEF_VERSION_MAIN
#define _XJ_MACRO_DEF_VERSION_MAIN 1
#endif
#ifndef _XJ_MACRO_DEF_VERSION_SUB
#define _XJ_MACRO_DEF_VERSION_SUB 2
#endif
#ifndef _XJ_MACRO_DEF_VERSION_ORDER
#define _XJ_MACRO_DEF_VERSION_ORDER 0
#endif
#ifndef _XJ_MACRO_DEF_VERSION_DATA
#define _XJ_MACRO_DEF_VERSION_DATA 230317
#endif

enum LocalRegType
{
	TP_PSB = 0,
	TP_SPSB,
	TP_PSW,
	TP_PFW,
	TP_SPSW,
	TP_SPFW,
	TP_COUNT,
};

enum VarDataType
{
	DT_Bit = 0x1,
	DT_Byte = 0x2,
	DT_WORD = 0x4,
	DT_DWORD = 0x8,
	DT_DDWORD = 0x10,
	DT_String = 0x20,
	DT_Bytes = 0x40,
	DT_Words = 0x80,
	DT_DWords = 0x100,
	DT_DDWords = 0x200,
};

enum NewVarDataType
{
	//DT_Bit = 0x1,
	//DT_Byte = 0x2,
	DT_Word = 0x4,
	DT_DWord = 0x8,
	DT_DDWord = 0x10,
	//DT_String = 0x20,
	DT_Byte_String = 0x40,
	DT_Word_String = 0x80,
	DT_DWord_String = 0x100,
	DT_DDWord_String = 0x200,
};

#define XJ_RETURN return

#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN 22
#endif

typedef int(*_Sys_HMIMacroApi)(const char* apiid, void *param);
extern int _MID(int mapid);
//#define  MacroMain()  _MacroMain(_Sys_HMIMacroApi _api)
typedef char bool;
typedef unsigned int DWORD;
typedef unsigned short WORD;
/*********************************************************************/
#define GetBit(varId)  _GetBit(varId,_g_api,&_g_erro)
extern bool _GetBit(int varId, _Sys_HMIMacroApi api, int *err);

#define Beep()  _Beep(_g_api, &_g_erro)
extern void _Beep(_Sys_HMIMacroApi api, int *err);

#define Lock(id) _Lock(id, _g_api, &_g_erro)
extern void _Lock(int id, _Sys_HMIMacroApi api, int *err);

#define UnLock(id) _UnLock(id, _g_api, &_g_erro)
extern void _UnLock(int id, _Sys_HMIMacroApi api, int *err);

#define CodeSysRead(devId, labName, count, labType, buf) _CodeSysRead(devId, labName, count, labType, buf, _g_api, &_g_erro)
extern bool _CodeSysRead(int devId, char* labName, int count, int labType, void *buf, _Sys_HMIMacroApi api, int *err);

#define CodeSysWrite(devId, labName, count, labType, buf) _CodeSysWrite(devId, labName, count, labType, buf, _g_api, &_g_erro)
extern bool _CodeSysWrite(int devId, char* labName, int count, int labType, void *buf, _Sys_HMIMacroApi api, int *err);

#define CodeSysReadString(devId, labName, count, len, buf) _CodeSysReadString(devId, labName, count, len, buf, _g_api, &_g_erro)
extern bool _CodeSysReadString(int devId, char* labName, int count, int len, void *buf, _Sys_HMIMacroApi api, int *err);

#define CodeSysWriteString(devId, labName, count, len, buf) _CodeSysWriteString(devId, labName, count, len, buf, _g_api, &_g_erro)
extern bool _CodeSysWriteString(int devId, char* labName, int count, int len, void *buf, _Sys_HMIMacroApi api, int *err);

#define Delay(ms)  _Delay(ms, _g_api, &_g_erro)
extern void _Delay(unsigned int ms, _Sys_HMIMacroApi api, int *err);

#define MakeDCID(winID, DCOrder)  _MakeDCID(winID, DCOrder, _g_api, &_g_erro)
extern unsigned int _MakeDCID(WORD winID, WORD DCOrder, _Sys_HMIMacroApi api, int *err);

#define DCMapClear(DCMapID)  _DCMapClear(_MID(DCMapID), _g_api, &_g_erro)
extern bool _DCMapClear(unsigned int DCMapID, _Sys_HMIMacroApi api, int *err);

#define DCMapSetBackColor(DCMapID, backColor)  _DCMapSetBackColor(_MID(DCMapID), backColor, _g_api, &_g_erro)
extern bool _DCMapSetBackColor(unsigned int DCMapID, unsigned int backColor, _Sys_HMIMacroApi api, int *err);

#define DCMapDrawLine(DCMapID, x, y, width, height, linewidth, color)  _DCMapDrawLine(_MID(DCMapID), x, y, width, height, linewidth, color, _g_api, &_g_erro)
extern bool _DCMapDrawLine(unsigned int DCMapID, int x, int y, int width, int height, int linewidth, unsigned int color, _Sys_HMIMacroApi api, int *err);

#define DCMapDrawRect(DCMapID, x, y,width, height, linewidth, color, fillRect, fillColor)  _DCMapDrawRect(_MID(DCMapID), x, y, width, height, linewidth, color, fillRect, fillColor, _g_api, &_g_erro)
extern bool _DCMapDrawRect(unsigned int DCMapID, int x, int y, int width, int height, int linewidth, unsigned int color, bool fillRect, unsigned int fillColor, _Sys_HMIMacroApi api, int *err);

#define DCMapDrawCircle(DCMapID, x, y, radius, linewidth, color, fillRect, fillColor)  _DCMapDrawCircle(_MID(DCMapID), x, y, radius, linewidth, color, fillRect, fillColor, _g_api, &_g_erro)
extern bool _DCMapDrawCircle(unsigned int DCMapID, int x, int y, int radius, int linewidth, unsigned int color, bool fillRect, unsigned int fillColor, _Sys_HMIMacroApi api, int *err);

#define DCMapDrawEllipse(DCMapID, x, y, xAxisLen, yAxisLen, linewidth, color, fillRect, fillColor) _DCMapDrawEllipse(_MID(DCMapID), x, y, xAxisLen, yAxisLen, linewidth, color, fillRect, fillColor, _g_api, &_g_erro)
extern bool _DCMapDrawEllipse(unsigned int DCMapID, int x, int y, int xAxisLen, int yAxisLen, int linewidth, unsigned int color, bool fillRect, unsigned int fillColor, _Sys_HMIMacroApi api, int *err);

#define DCMapDrawCircleArc(DCMapID, x, y, radius, linewidth, color, startAngle, endAngle)  _DCMapDrawCircleArc(_MID(DCMapID), x, y, radius, linewidth, color, startAngle, endAngle, _g_api, &_g_erro)
extern bool _DCMapDrawCircleArc(DWORD DCMapID, int x, int y, int radius, int linewidth, DWORD color, DWORD startAngle, DWORD endAngle, _Sys_HMIMacroApi api, int *err);

#define DCMapDrawEllipseArc(DCMapID, x, y, xAxisLen, yAxisLen, linewidth, color, startAngle, endAngle) _DCMapDrawEllipseArc(_MID(DCMapID), x, y, xAxisLen, yAxisLen, linewidth, color, startAngle, endAngle, _g_api, &_g_erro)
extern bool _DCMapDrawEllipseArc(DWORD DCMapID, int x, int y, int xAxisLen, int yAxisLen, int linewidth, DWORD color, DWORD startAngle, DWORD endAngle, _Sys_HMIMacroApi api, int *err);

#define OpenWindow(winNo, winX, winY)  _OpenWindow(winNo, winX, winY, _g_api, &_g_erro)
extern void _OpenWindow(WORD winNo, WORD winX, WORD winY, _Sys_HMIMacroApi api, int *err);

#define ScreenJump(screenNo)  _ScreenJump(screenNo, _g_api, &_g_erro)
extern WORD _ScreenJump(WORD screenNo, _Sys_HMIMacroApi api, int *err);

#define CloseWindow(winNo)  _CloseWindow(winNo, _g_api, &_g_erro)
extern void _CloseWindow(WORD winNo, _Sys_HMIMacroApi api, int *err);

#define Reads(devID, staNo, regType, dataType, addr, addr1, count, buf) _Reads(devID, staNo, regType, dataType, addr, addr1, count, buf, _g_api, &_g_erro)
extern bool  _Reads(int devID, int staNo, int regType, int dataType, int addr, int addr1, int count, void* buf, _Sys_HMIMacroApi api, int *err);

#define Writes(devID, staNo, regType, dataType, addr, addr1, count, buf) _Writes(devID, staNo, regType, dataType, addr, addr1, count, buf, _g_api, &_g_erro)
extern bool  _Writes(int devID, int staNo, int regType, int dataType, int addr, int addr1, int count, void* buf, _Sys_HMIMacroApi api, int *err);

#define Read(devID, staNo, regType, dataType, addr, addr1, buf) _ReadExs(devID, staNo, regType, dataType, addr, addr1, buf, _g_api, &_g_erro)
extern bool  _ReadExs(int devID, int staNo, int regType, int dataType, int addr, int addr1, void* buf, _Sys_HMIMacroApi api, int *err);

#define Write(devID, staNo, regType, dataType, addr, addr1, data) _WriteExs(devID, staNo, regType, dataType, addr, addr1, data, _g_api, &_g_erro)
extern bool  _WriteExs(int devID, int staNo, int regType, int dataType, int addr, int addr1, unsigned long long data, _Sys_HMIMacroApi api, int *err);

#define WriteF(devID, staNo, regType, dataType, addr, addr1, data) _WriteFExs(devID, staNo, regType, dataType, addr, addr1, data, _g_api, &_g_erro)
extern bool  _WriteFExs(int devID, int staNo, int regType, int dataType, int addr, int addr1, double data, _Sys_HMIMacroApi api, int *err);

#define GetPSB(addr)  _GetPSB(addr, _g_api, &_g_erro)
extern bool _GetPSB(DWORD addr, _Sys_HMIMacroApi api, int *err);

#define SetPSB(addr, val)  _SetPSB(addr, val, _g_api, &_g_erro)
extern void _SetPSB(DWORD addr, bool val, _Sys_HMIMacroApi api, int *err);

#define GetSPSB(addr)  _GetSPSB(addr, _g_api, &_g_erro)
extern bool _GetSPSB(DWORD addr, _Sys_HMIMacroApi api, int *err);

#define SetSPSB(addr, val)  _SetSPSB(addr, val, _g_api, &_g_erro)
extern void _SetSPSB(DWORD addr, bool val, _Sys_HMIMacroApi api, int *err);

#define PSW _PSW(_g_api, &_g_erro)
extern unsigned short* _PSW(_Sys_HMIMacroApi api, int *err);

#define SPSW _SPSW(_g_api, &_g_erro)
extern unsigned short* _SPSW(_Sys_HMIMacroApi api, int *err);

#define ReadPFW(addr, len, buf)  _ReadPFW(addr, len, buf, _g_api, &_g_erro)
extern void _ReadPFW(int addr, int len, void* buf, _Sys_HMIMacroApi api, int *err);

#define WritePFW(addr, len, buf)  _WritePFW(addr, len, buf, _g_api, &_g_erro)
extern void _WritePFW(int addr, int len, void* buf, _Sys_HMIMacroApi api, int *err);

#define ReadSPFW(addr, len, buf)  _ReadSPFW(addr, len, buf, _g_api, &_g_erro)
extern void _ReadSPFW(int addr, int len, void* buf, _Sys_HMIMacroApi api, int *err);

#define WriteSPFW(addr, len, buf)  _WriteSPFW(addr, len, buf, _g_api, &_g_erro)
extern void _WriteSPFW(int addr, int len, void* buf, _Sys_HMIMacroApi api, int *err);

#define Func_SetBit(param)  _Func_SetBit(param, _g_api, &_g_erro)
extern void _Func_SetBit(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_SetData(param)  _Func_SetData(param, _g_api, &_g_erro)
extern void _Func_SetData(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_Calculator(param)  _Func_Calculator(param, _g_api, &_g_erro)
extern void _Func_Calculator(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_ChangeScreen(param)  {\
	_Func_ChangeScreen(param, _g_api, &_g_erro);\
	XJ_RETURN;\
}
extern void _Func_ChangeScreen(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_CallWindow(param) {\
struct CallWindowParam* p = (struct CallWindowParam*)param;\
 _Func_CallWindow(param, _g_api, &_g_erro);\
if(p->opertion == 0)\
{\
	if(p->SourceWinNum != p->WindowNumber)\
	{\
		if(!((p->SourceWinNum <= USER_SCREEN_MAX) && (p->WindowNumber > USER_SCREEN_MAX)))\
		{\
			XJ_RETURN;\
		}\
	}\
}\
}
extern void _Func_CallWindow(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_CloseWindow(param)  {\
struct CloseWindowParam* p = (struct CloseWindowParam*)param;\
_Func_CloseWindow(param, _g_api, &_g_erro);\
if(p->CloseAll == 1 || p->SourceWinNum == p->WindowNumber)\
{\
		XJ_RETURN;\
}\
}
extern void _Func_CloseWindow(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_CallFunc(param)  _Func_CallFunc(param, _g_api, &_g_erro)
extern void _Func_CallFunc(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_MoveVarDatas(param)  _Func_MoveVarDatas(param, _g_api, &_g_erro)
extern void _Func_MoveVarDatas(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_UpLoadRecipe(param)  _Func_UpLoadRecipe(param, _g_api, &_g_erro)
extern void _Func_UpLoadRecipe(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_DownLoadRecipe(param)  _Func_DownLoadRecipe(param, _g_api, &_g_erro)
extern void _Func_DownLoadRecipe(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_ImportCSV(param)  _Func_ImportCSV(param, _g_api, &_g_erro)
extern void _Func_ImportCSV(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_ExportCSV(param)  _Func_ExportCSV(param, _g_api, &_g_erro)
extern void _Func_ExportCSV(char* param, _Sys_HMIMacroApi api, int *err);

#define Func_PrintfScreen(param)  _Func_PrintfScreen(param, _g_api, &_g_erro)
extern void _Func_PrintfScreen(char* param, _Sys_HMIMacroApi api, int *err);

#define EndFunction(param)  _Func_EndFunction(param, _g_api, &_g_erro)
extern void _Func_EndFunction(char* param, _Sys_HMIMacroApi api, int *err);

#define NetInit(param)  _NetInit(param, _g_api, &_g_erro)
extern void _NetInit(char* param, _Sys_HMIMacroApi api, int *err);

#define ServerInit(param)  _ServerInit(param, _g_api, &_g_erro)
extern void _ServerInit(char* param, _Sys_HMIMacroApi api, int *err);

#define ServerExit(param)  _ServerExit(param, _g_api, &_g_erro)
extern void _ServerExit(char* param, _Sys_HMIMacroApi api, int *err);

#define ClientInit(param)  _ClientInit(param, _g_api, &_g_erro)
extern void _ClientInit(char* param, _Sys_HMIMacroApi api, int *err);

#define ClientExit(param)  _ClientExit(param, _g_api, &_g_erro)
extern void _ClientExit(char* param, _Sys_HMIMacroApi api, int *err);

#define ClientRead(ID, buf, len, outtime)  _ClientRead(ID, buf, len, outtime, _g_api, &_g_erro)
extern int _ClientRead(unsigned short ID, void* buf, int len, int outtime, _Sys_HMIMacroApi api, int *err);

#define ClientWrite(ID, buf, len)  _ClientWrite(ID, buf, len, _g_api, &_g_erro)
extern int _ClientWrite(unsigned short ID, void* buf, int len, _Sys_HMIMacroApi api, int *err);


#define GetCAMVersion(buf, len) _GetCAMVersion(buf, len, _g_api, &_g_erro)
extern int _GetCAMVersion(void* buf, int len, _Sys_HMIMacroApi api, int *err);

#define GetCADVersion(buf, len) _GetCADVersion(buf, len, _g_api, &_g_erro)
extern int _GetCADVersion(void* buf, int len, _Sys_HMIMacroApi api, int *err);

#define GetRTraceVersion(buf, len) _GetRTraceVersion(buf, len, _g_api, &_g_erro)
extern int _GetRTraceVersion(void* buf, int len, _Sys_HMIMacroApi api, int *err);

#define GetNCTotalLines() _GetNCTotalLines(_g_api, &_g_erro)
extern int _GetNCTotalLines(_Sys_HMIMacroApi api, int *err);

#define GetNCVersion(buf, len) _GetNCVersion(buf, len, _g_api, &_g_erro)
extern int _GetNCVersion(void* buf, int len, _Sys_HMIMacroApi api, int *err);

#define SetCAD(x, y, width, height) _SetCAD(x, y, width, height, _g_api, &_g_erro)
extern void _SetCAD(int x, int y, int width, int height, _Sys_HMIMacroApi api, int *err);

#define HideCAD() _HideCAD(_g_api, &_g_erro)
extern void _HideCAD(_Sys_HMIMacroApi api, int *err);

#define ShowCAD() _ShowCAD(_g_api, &_g_erro)
extern void _ShowCAD(_Sys_HMIMacroApi api, int *err);

#define ResetCAD() _ResetCAD(_g_api, &_g_erro)
extern void _ResetCAD(_Sys_HMIMacroApi api, int *err);

#define StartRTrace() _StartRTrace(_g_api, &_g_erro)
extern void _StartRTrace(_Sys_HMIMacroApi api, int *err);

#define StopRTrace() _StopRTrace(_g_api, &_g_erro)
extern void _StopRTrace(_Sys_HMIMacroApi api, int *err);

#define SetRTraceChannel(number, enable) _SetRTraceChannel(number, enable, _g_api, &_g_erro)
extern int _SetRTraceChannel(int number, bool enable, _Sys_HMIMacroApi api, int *err);

#define ResetRTrace() _ResetRTrace(_g_api, &_g_erro)
extern void _ResetRTrace(_Sys_HMIMacroApi api, int *err);

#define ShowDialog(buf, len) _ShowDialog(buf, len , _g_api, &_g_erro)
extern int _ShowDialog(char* buf, int len, _Sys_HMIMacroApi api, int *err);

#define StopShowDialog(buf, len) _StopShowDialog(-1, buf, len , _g_api, &_g_erro)
extern int _StopShowDialog(int id, char* buf, int len, _Sys_HMIMacroApi api, int *err);

#define SetNCLines(number) _SetNCLines(number, _g_api, &_g_erro)
extern int _SetNCLines(int number, _Sys_HMIMacroApi api, int *err);

#define SetNC(x, y, width, height) _SetNC(x, y, width, height, _g_api, &_g_erro)
extern void _SetNC(int x, int y, int width, int height, _Sys_HMIMacroApi api, int *err);

#define HideNC() _HideNC(_g_api, &_g_erro)
extern void _HideNC(_Sys_HMIMacroApi api, int *err);

#define ShowNC() _ShowNC(_g_api, &_g_erro)
extern void _ShowNC(_Sys_HMIMacroApi api, int *err);

#define ResetNC() _ResetNC(_g_api, &_g_erro)
extern void _ResetNC(_Sys_HMIMacroApi api, int *err);

#define ImportFileToCAD(buf, len) _ImportFileToCAD(buf, len, _g_api, &_g_erro)
extern int _ImportFileToCAD(void* buf, int len, _Sys_HMIMacroApi api, int *err);

#define ImportFileToNCView(buf, len) _ImportFileToNCView(buf, len, _g_api, &_g_erro)
extern int _ImportFileToNCView(void* buf, int len, _Sys_HMIMacroApi api, int *err);

#define ImportFileToNCWork(buf, len) _ImportFileToNCWork(buf, len, _g_api, &_g_erro)
extern int _ImportFileToNCWork(void* buf, int len, _Sys_HMIMacroApi api, int *err);


#define COMSend(devId, buf, len) _COMSend(devId, buf, len, _g_api, &_g_erro)
extern int _COMSend(int devId, char* buf, int len, _Sys_HMIMacroApi api, int *err);

#define COMReceive(devId, buf, len, timeOut, timeBytes) _COMReceive(devId, buf, len, timeOut, timeBytes, _g_api, &_g_erro)
extern int _COMReceive(int devId, char* buf, int len, unsigned short timeOut, unsigned short timeBytes, _Sys_HMIMacroApi api, int *err);

#define TCPClientSend(devId, buf, len) _TCPClientSend(devId, buf, len, _g_api, &_g_erro)
extern int _TCPClientSend(int devId, char* buf, int len, _Sys_HMIMacroApi api, int *err);

#define TCPClientReceive(devId, buf, len, timeOut) _TCPClientReceive(devId, buf, len, timeOut, _g_api, &_g_erro)
extern int _TCPClientReceive(int devId, char* buf, int len, unsigned short timeOut, _Sys_HMIMacroApi api, int *err);

#define GetConnections(devId, number, socket, ipAddr, ipPort) _GetConnections(devId, number, socket, ipAddr, ipPort, _g_api, &_g_erro)
extern int _GetConnections(int devId, unsigned char number, int* socket, char* ipAddr, unsigned short* ipPort, _Sys_HMIMacroApi api, int *err);

#define UDPSend(devId, ipAddr, ipPort, buf, len) _UDPSend(devId, ipAddr, ipPort, buf, len, _g_api, &_g_erro)
extern int _UDPSend(int devId, char* ipAddr, unsigned short ipPort, char* buf, int len, _Sys_HMIMacroApi api, int *err);

#define UDPReceive(devId, ipAddr, ipPort, buf, len, timeOut) _UDPReceive(devId, ipAddr, ipPort, buf, len, timeOut, _g_api, &_g_erro)
extern int _UDPReceive(int devId, char* ipAddr, unsigned short* ipPort, char* buf, int len, unsigned short timeOut, _Sys_HMIMacroApi api, int *err);

#define TCPServerSend(devId, socket, buf, len) _TCPServerSend(devId, socket, buf, len, _g_api, &_g_erro)
extern int _TCPServerSend(int devId, int* socket, char* buf, int len, _Sys_HMIMacroApi api, int *err);

#define TCPServerReceive(devId, socket, buf, len, timeOut) _TCPServerReceive(devId, socket, buf, len, timeOut, _g_api, &_g_erro)
extern int _TCPServerReceive(int devId, int* socket, char* buf, int len, unsigned short timeOut, _Sys_HMIMacroApi api, int *err);

